/*
---------------------- Apache Version 2.0 License ----------------------
Copyright 2023 René Steger

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
------------------------------------------------------------------------
*/

-- create an instance of the Rexx class
rexxHandler=.RexxAppHandler~new
-- the abstract "start" method will be served by rexxHandler
rxApp=BSFCreateRexxProxy(rexxHandler, ,"javafx.application.Application")
-- launch the application and invokes "start"
rxApp~launch(rxApp~getClass, .nil)

-- get Java Support
::REQUIRES "BSF.CLS"

-- the Rexx handler for javafx.application.Application
::CLASS RexxAppHandler

-- will be called by JavaFX
::METHOD start
-- accesses the primary stage
USE ARG primaryStage

-- setting title to the Stage
primaryStage~setTitle("Cylinder_Material")

-- import class Cylinder
cylinder=bsf.import("javafx.scene.shape.Cylinder")
-- import class PhongMaterial
phMa=bsf.import("javafx.scene.paint.PhongMaterial")
-- get access to the JavaFX colors
col=bsf.loadClass("javafx.scene.paint.Color")

-- create the root node
root=.bsf~new("javafx.scene.Group")

-- create a cylinder
cylinder1=cylinder~new
-- set the radius and the height of the cylinder
cylinder1~radius=50
cylinder1~height=200
-- set position of the cylinder
cylinder1~translateX=150
cylinder1~translateY=150

-- preparing the material
material1=phMa~new
material1~diffuseColor=col~BURLYWOOD

-- set the material to cylinder
cylinder1~setMaterial(material1)

cylinder2=cylinder~new
cylinder2~radius=50
cylinder2~height=200
cylinder2~translateX=400
cylinder2~translateY=150

material2=phMa~new
material2~specularColor=col~BURLYWOOD

cylinder2~setMaterial(material2)

cylinder3=cylinder~new
cylinder3~radius=50
cylinder3~height=200
cylinder3~translateX=650
cylinder3~translateY=150

material3=phMa~new
material3~specularPower=10

cylinder3~setMaterial(material3)

-- add the objects to the root node
root~getChildren~~add(cylinder1)~~add(cylinder2)~~add(cylinder3)

-- create a perspective camera
camera=.bsf~new("javafx.scene.PerspectiveCamera")
-- set position of the camera
camera~translateX=0
camera~translateY=0
camera~translateZ=0

-- create a scene
scene=.bsf~new("javafx.scene.Scene", root, 800, 600)
-- add camera to the scene
scene~setCamera(camera)

-- put the scene on the stage
primaryStage~setScene(scene)
-- display the content of the stage
primaryStage~show